//
//  AHKMail.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Sun Apr 17 2005.
//  Copyright 2005-2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.//
//

#import "AHKMail.h"


@implementation AHKMail

#pragma mark init and dealloc
- (id)initWithData:(NSData *)datum box:(int)aBox number:(int)aNumber status:(int)aStatus isSecured:(BOOL)flag
{
	self = [super init];
	if (self != nil) {
		[self setBox:aBox];
		[self setNumber:aNumber];
		[self setStatus:aStatus];
		[self setSecured:flag];
		[self setData:datum];
	}
	return self;
}

- (void)dealloc
{
	[self setData:nil];
	
	[super dealloc];
}

#pragma mark NSCoding
- (id)initWithCoder:(NSCoder *)coder
{
	// if the superclass supports NSCoding protocol, use [super initWithCoder:coder].
	// else, use superclass's designated initializer.
	self = [super init];
	
	[self setNumber:[coder decodeIntForKey:@"number"]];
	[self setBox:[coder decodeIntForKey:@"box"]];
	[self setStatus:[coder decodeIntForKey:@"status"]];
	[self setSecured:[coder decodeBoolForKey:@"secured"]];
	
	[self setData:[coder decodeObjectForKey:@"data"]];
	
	return self;
}

- (void)encodeWithCoder:(NSCoder *)coder
{
	//	[super encodeWithCoder:coder]; // if super class supports NSCoding protocol
	[coder encodeInt:box forKey:@"box"];
	[coder encodeInt:number forKey:@"number"];
	[coder encodeInt:status forKey:@"status"];
	[coder encodeBool:secured forKey:@"secured"];
	
	[coder encodeObject:data forKey:@"data"];
}

#pragma mark accessor methods

- (int)number
{
	return number;
}

- (void)setNumber:(int)value
{
	number = value;
}

- (int)box
{
	return box;
}
- (void)setBox:(int)value
{
	box = value;
}

- (int)status
{
	return status;
}

- (void)setStatus:(int)value
{
	status = value;
}

- (BOOL)isSecured
{
	return secured;
}

- (void)setSecured:(BOOL)flag
{
	secured = flag;
}

- (NSData *)data
{
	return data;
}

- (void)setData:(NSData *)value
{
	if (data != value) {
		[data release];
		data = [value copy];
	}
}

@end
